// C Source File
// Created 26/08/2007; 18:05:13

#include <tigcclib.h>

#include "fonctions graphiques.h"

void rect(short x1,short y1,short x2,short y2,short plane) //trace un rectangle
{
	 GraySetAMSPlane (plane);
	 DrawLine (x1, y1, x1, y2,A_NORMAL); 
	 DrawLine (x1, y1, x2, y1,A_NORMAL); 
	 DrawLine (x2, y1, x2, y2,A_NORMAL); 
	 DrawLine (x1, y2, x2, y2,A_NORMAL);
}

void FillRect(short plane, short x1,short y1,short x2,short y2, short Attr) //trace un rectangle plein
{
	 GraySetAMSPlane (plane);
	 ScrRectFill (&(SCR_RECT){{x1, y1, x2, y2}}, &(SCR_RECT){{0, 0, 239, 127}},Attr);
}

inline void affiche_level(char* light, char* dark)
{
	int j, k ;
	for (j=0;j<LEVEL_HEIGHT;j++)
	{
		for (k=0;k<LEVEL_WIDTH;k++)
		{
			switch (m[j][k])
			{
				case BRIQUE					: GrayTile8x8_RPLC_R(X8(k),Y(J),carre1, carre2,light,dark); break;
				case PIC_EN_HAUT			: GrayTile8x8_RPLC_R(X8(k),Y(J),pic1[HAUT-1], pic2[HAUT-1],light,dark); break;
				case PIC_A_GAUCHE			: GrayTile8x8_RPLC_R(X8(k),Y(J),pic1[GAUCHE-1], pic2[GAUCHE-1],light,dark); break;
				case PIC_EN_BAS				: GrayTile8x8_RPLC_R(X8(k),Y(J),pic1[BAS-1], pic2[BAS-1],light,dark); break;
				case PIC_A_DROITE			: GrayTile8x8_RPLC_R(X8(k),Y(J),pic1[DROITE-1], pic2[DROITE-1],light,dark); break;
				case ARRIVEE 				: GrayTile8x8_RPLC_R(X8(k),Y(J),arrive, arrive,light,dark); break;
				case MINE					: GrayTile8x8_RPLC_R(X8(k),Y(J),pics1, pics2,light,dark); break;
				case GLACE					: GrayTile8x8_RPLC_R(X8(k),Y(J),glace1, glace2,light,dark); break;
				case GRAVITE_PLUS			: GrayTile8x8_RPLC_R(X8(k), Y(J), plus, plus, light, dark); break;
				case GRAVITE_NORMALE		: GrayTile8x8_RPLC_R(X8(k), Y(J), zero, zero, light, dark); break;
				case CHECKPOINT				: GrayTile8x8_RPLC_R(X8(k), Y(J), checkpoint1, checkpoint2, light, dark); break;
				case GRAVITE_INVERSE		: GrayTile8x8_RPLC_R(X8(k), Y(J), moins, moins, light, dark); break;
				case TOUCHES				: 
				case TOUCHES_GAUCHE_DROITE	: 
				case TOUCHES_HAUT_BAS		: GrayTile8x8_RPLC_R(X8(k), Y(J), pave1[m[j][k]-TOUCHES], pave2[m[j][k]-TOUCHES], light, dark); break;
				case INVERSE_TOUT			:
				case INVERSE_GAUCHE_DROITE	:
				case INVERSE_HAUT_BAS		: GrayTile8x8_RPLC_R(X8(k), Y(J), inverse1[m[j][k]-INVERSE_TOUT], inverse2[m[j][k]-INVERSE_TOUT], light, dark); break;	
			}
		}
	}
}

void affiche_curs( int curs) //affiche le curseur
{
	FillRect(LIGHT_PLANE,X(20),Y(15*curs+14),X(138),Y(15*curs+23),A_XOR);
}

void drawbox(int x1,int y1,int x2,int y2) //boite de dialogue
{
	FillRect(DARK_PLANE, x1, y1, x2, y2, A_REVERSE);
	FillRect(LIGHT_PLANE, x1, y1, x2, y2, A_REVERSE);
	rect(x1, y1, x2, y2, DARK_PLANE);
	rect(x1, y1, x2, y2, LIGHT_PLANE);
	rect(x1, y1, x2-1, y2-1, DARK_PLANE);
	FillRect(LIGHT_PLANE, x1+2, y1+2, x2-2, y2-2, A_NORMAL);
}

void draw_center_dialogbox( const char* str1, const char* str2 )
{
	int width1 = strlen( str1 ) * 6 + 1;
	int width2 = DrawStrWidth( str2, F_4x6 );
	int max_width = max( width1, width2 );
	int pos1_x = (160-width1)/2;
	int pos2_x = (160-width2)/2;
	int pos_box_x = (160-max_width)/2;

	drawbox( X(pos_box_x-5), Y(36), X(pos_box_x+max_width+5), Y(60));
	
	GraySetAMSPlane (DARK_PLANE);
	DrawStr( X(pos1_x  ), Y(40), str1, A_XOR );
	FontSetSys(0);
	DrawStr( X(pos2_x  ), Y(52), str2, A_NORMAL );
	FontSetSys(1);
	
	GraySetAMSPlane (LIGHT_PLANE);
	DrawStr( X(pos1_x+1), Y(41), str1, A_XOR );
	FontSetSys(0);
	DrawStr( X(pos2_x), Y(52), str2, A_NORMAL );
	FontSetSys(1);
}

void virtuel2reel(char* light, char* dark)
{
	FastCopyScreen_R(light, GrayGetPlane(LIGHT_PLANE));
	FastCopyScreen_R(dark, GrayGetPlane(DARK_PLANE));
}